﻿export function Clipboard(fieldId) {
    /* Get the text field */
    var copyText = document.getElementById(fieldId);
    /* Copy the text inside the text field */
    navigator.clipboard.writeText(copyText.value);
}
export function ClipboardText(copyText) {
    /* Copy the text inside the text field */
    navigator.clipboard.writeText(copyText);
}
export function ACSClipboardText(text) {
    window.clipboardData.setData("Text", text);
}
export function testClipboard() {
    navigator.clipboard
        .writeText(document.getElementById('copy-text').innerText)
        .then(
            success => console.log("text copied"), err => console.log("error copying text")
        );
}

// SIG // Begin signature block
// SIG // MIIoGgYJKoZIhvcNAQcCoIIoCzCCKAcCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // 5+nHN/v/PMBnRgWPBy0OQBMr7HYM7qrZ6CtJ6cqLQMOg
// SIG // gg2OMIIGsDCCBJigAwIBAgIQCK1AsmDSnEyfXs2pvZOu
// SIG // 2TANBgkqhkiG9w0BAQwFADBiMQswCQYDVQQGEwJVUzEV
// SIG // MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
// SIG // d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
// SIG // dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjEwNDI5MDAwMDAw
// SIG // WhcNMzYwNDI4MjM1OTU5WjBpMQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
// SIG // OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
// SIG // IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMIICIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA1bQvQtAorXi3
// SIG // XdU5WRuxiEL1M4zrPYGXcMW7xIUmMJ+kjmjYXPXrNCQH
// SIG // 4UtP03hD9BfXHtr50tVnGlJPDqFX/IiZwZHMgQM+TXAk
// SIG // ZLON4gh9NH1MgFcSa0OamfLFOx/y78tHWhOmTLMBICXz
// SIG // ENOLsvsI8IrgnQnAZaf6mIBJNYc9URnokCF4RS6hnyzh
// SIG // GMIazMXuk0lwQjKP+8bqHPNlaJGiTUyCEUhSaN4QvRRX
// SIG // XegYE2XFf7JPhSxIpFaENdb5LpyqABXRN/4aBpTCfMjq
// SIG // GzLmysL0p6MDDnSlrzm2q2AS4+jWufcx4dyt5Big2MEj
// SIG // R0ezoQ9uo6ttmAaDG7dqZy3SvUQakhCBj7A7CdfHmzJa
// SIG // wv9qYFSLScGT7eG0XOBv6yb5jNWy+TgQ5urOkfW+0/tv
// SIG // k2E0XLyTRSiDNipmKF+wc86LJiUGsoPUXPYVGUztYuBe
// SIG // M/Lo6OwKp7ADK5GyNnm+960IHnWmZcy740hQ83eRGv7b
// SIG // UKJGyGFYmPV8AhY8gyitOYbs1LcNU9D4R+Z1MI3sMJN2
// SIG // FKZbS110YU0/EpF23r9Yy3IQKUHw1cVtJnZoEUETWJrc
// SIG // JisB9IlNWdt4z4FKPkBHX8mBUHOFECMhWWCKZFTBzCEa
// SIG // 6DgZfGYczXg4RTCZT/9jT0y7qg0IU0F8WD1Hs/q27Iwy
// SIG // CQLMbDwMVhECAwEAAaOCAVkwggFVMBIGA1UdEwEB/wQI
// SIG // MAYBAf8CAQAwHQYDVR0OBBYEFGg34Ou2O/hfEYb7/mF7
// SIG // CIhl9E5CMB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/n
// SIG // upiuHA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB3BggrBgEFBQcBAQRrMGkwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBB
// SIG // BggrBgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNl
// SIG // cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQw
// SIG // QwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGln
// SIG // aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5j
// SIG // cmwwHAYDVR0gBBUwEzAHBgVngQwBAzAIBgZngQwBBAEw
// SIG // DQYJKoZIhvcNAQEMBQADggIBADojRD2NCHbuj7w6mdNW
// SIG // 4AIapfhINPMstuZ0ZveUcrEAyq9sMCcTEp6QRJ9L/Z6j
// SIG // fCbVN7w6XUhtldU/SfQnuxaBRVD9nL22heB2fjdxyyL3
// SIG // WqqQz/WTauPrINHVUHmImoqKwba9oUgYftzYgBoRGRjN
// SIG // YZmBVvbJ43bnxOQbX0P4PpT/djk9ntSZz0rdKOtfJqGV
// SIG // WEjVGv7XJz/9kNF2ht0csGBc8w2o7uCJob054ThO2m67
// SIG // Np375SFTWsPK6Wrxoj7bQ7gzyE84FJKZ9d3OVG3ZXQIU
// SIG // H0AzfAPilbLCIXVzUstG2MQ0HKKlS43Nb3Y3LIU/Gs4m
// SIG // 6Ri+kAewQ3+ViCCCcPDMyu/9KTVcH4k4Vfc3iosJocsL
// SIG // 6TEa/y4ZXDlx4b6cpwoG1iZnt5LmTl/eeqxJzy6kdJKt
// SIG // 2zyknIYf48FWGysj/4+16oh7cGvmoLr9Oj9FpsToFpFS
// SIG // i0HASIRLlk2rREDjjfAVKM7t8RhWByovEMQMCGQ8M4+u
// SIG // KIw8y4+ICw2/O/TOHnuO77Xry7fwdxPm5yg/rBKupS8i
// SIG // bEH5glwVZsxsDsrFhsP2JjMMB0ug0wcCampAMEhLNKhR
// SIG // ILutG4UI4lkNbcoFUCvqShyepf2gpx8GdOfy1lKQ/a+F
// SIG // SCH5Vzu0nAPthkX0tGFuv2jiJmCG6sivqf6UHedjGzqG
// SIG // VnhOMIIG1jCCBL6gAwIBAgIQCC2MFtJ1dCZDA7Yrcl1L
// SIG // 6DANBgkqhkiG9w0BAQsFADBpMQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
// SIG // OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
// SIG // IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMB4XDTI0MDIx
// SIG // MjAwMDAwMFoXDTI3MDIxMTIzNTk1OVowXjELMAkGA1UE
// SIG // BhMCU0UxDTALBgNVBAcTBEx1bmQxHzAdBgNVBAoTFkF4
// SIG // aXMgQ29tbXVuaWNhdGlvbnMgQUIxHzAdBgNVBAMTFkF4
// SIG // aXMgQ29tbXVuaWNhdGlvbnMgQUIwggGiMA0GCSqGSIb3
// SIG // DQEBAQUAA4IBjwAwggGKAoIBgQDpNEq9tgukB8w6abOq
// SIG // d/puHOB6xilvXY7tfmsLwlqTZ606wscXKguxXsYLd1VU
// SIG // dhnyPoRB65ElfYau7Qk9tDaNbODqhnQfxWrFL6qvIwrq
// SIG // FykEJ3eYKhYRc/2i/taHK9jb7QrMbjYoQVAN4rIhX9Ed
// SIG // Ll3BCKIvrVIstLyX+WbLaKTBLkkjmZQDYXVr8AU3fAy9
// SIG // RAWA6eGf7dZFi2sejSPH4ptTCcYuTmlVHdYWhUDG83gY
// SIG // sA15TFSQsmHElR+37igkYaHpuKV9YH3WzN8n4YoHoCT0
// SIG // botd2ouiOvV+9RqMkQgZ5AoJK8PJ1Kzhxo603vdLFy71
// SIG // UlNGLo91Wc3A5HcTderRxtkitzU/+3eRJoK1EsGm70t+
// SIG // rE0ctFXkgpqKeAcg5U1ApYxoj3Azub4osgxfUkWymtAU
// SIG // rlQAfcbWmqo8PfrFkcYlKh1avHETzspQXM4jjFRUhOBD
// SIG // XGh9wOeTdpG9rQWpUZtBj37wdcEcx3aMPwK3RmAdRWCK
// SIG // wYtiFHFLICsCAwEAAaOCAgMwggH/MB8GA1UdIwQYMBaA
// SIG // FGg34Ou2O/hfEYb7/mF7CIhl9E5CMB0GA1UdDgQWBBQg
// SIG // iE6PNVEUmlGohfgMKi6rsP+VHDA+BgNVHSAENzA1MDMG
// SIG // BmeBDAEEATApMCcGCCsGAQUFBwIBFhtodHRwOi8vd3d3
// SIG // LmRpZ2ljZXJ0LmNvbS9DUFMwDgYDVR0PAQH/BAQDAgeA
// SIG // MBMGA1UdJQQMMAoGCCsGAQUFBwMDMIG1BgNVHR8Ega0w
// SIG // gaowU6BRoE+GTWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
// SIG // bS9EaWdpQ2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNB
// SIG // NDA5NlNIQTM4NDIwMjFDQTEuY3JsMFOgUaBPhk1odHRw
// SIG // Oi8vY3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
// SIG // dGVkRzRDb2RlU2lnbmluZ1JTQTQwOTZTSEEzODQyMDIx
// SIG // Q0ExLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBc
// SIG // BggrBgEFBQcwAoZQaHR0cDovL2NhY2VydHMuZGlnaWNl
// SIG // cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0Q29kZVNpZ25p
// SIG // bmdSU0E0MDk2U0hBMzg0MjAyMUNBMS5jcnQwCQYDVR0T
// SIG // BAIwADANBgkqhkiG9w0BAQsFAAOCAgEAU5f66f9RDAuk
// SIG // V7jcGZmPEDUKc0jjgzpi2xVNYTJR6v4oqVjvrbAJx3we
// SIG // Ap2Za24JFWuuLMnJA9vYFjK2KdjzHU8LC/7x5lCNJWY9
// SIG // aSd8wrweRPuApypIWEiK3tcrpDMs2x0ecuV9m0OpFbUd
// SIG // JpCqg060/r5ummwTJjXFcHPo+SCfb4h7KZ3ALF/7e4J2
// SIG // A5jJxwlk0MEdNcDWMqRG5qX+WbRfNt9yObaMvsdkxgce
// SIG // z06HbmM8VohfRh3dfFDRrsjY7Cz5xyNHGN7xjTKORomo
// SIG // rEfXvwh2FKtePTHbkUYn8/ZJKvCQPNZNI/gxLGW/JTjk
// SIG // aAO4LXtNO8Z3rL9+Ti+Hs234Y5CmCAho0VUgf17vGIR9
// SIG // OF7OgGxVgQaKovfwx/UVd0tCx/ic8TSHg1MPC1u1TWK0
// SIG // jh1rkaj0ms5rVpZfjEFA1dKeCyFDJRI6FDbEQb7A2EjI
// SIG // mUkzYszIMqeN+1w79ufojvBjLYipcprDj7imACxVZ9Ey
// SIG // cXSHrSA9B512uetAtxcrBA8bBm1QiOi9ZfY+UQpphdal
// SIG // LO6NqHM75Q8qZXrANLDTkpaSRcck4L5V15aMSQh+2Gs/
// SIG // 9iLb4XzLdQmYTLcqd/GNclpYDKkk65SVcQHFxzl87v5h
// SIG // DGjbw06hf8xp1ubaHShRy9PdoUKpvvMRjToy9AvBvgcm
// SIG // drc0od8tUe4xghnkMIIZ4AIBATB9MGkxCzAJBgNVBAYT
// SIG // AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8G
// SIG // A1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNp
// SIG // Z25pbmcgUlNBNDA5NiBTSEEzODQgMjAyMSBDQTECEAgt
// SIG // jBbSdXQmQwO2K3JdS+gwDQYJYIZIAWUDBAIBBQCgfDAQ
// SIG // BgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMxDAYK
// SIG // KwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYKKwYB
// SIG // BAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgcl+L6+9fQcqg
// SIG // EqS08G3hIoanKQE4idoXi65htVQO0k4wDQYJKoZIhvcN
// SIG // AQEBBQAEggGAI+WmirWfaRRI2NGtpxUi7bKIySQJ/fHj
// SIG // iZ/WOAgYlEztyStOvfIqOv8N7DBbiZb2dpcZDF5J8OIl
// SIG // YTtbAqyUC7oOFBRx92Fyd7aQG0rB8x3u89UTHY/GBQ9W
// SIG // tzolEk4hUHGguHHMEOPuxs7xWokjV2ii30XsD/jgPiZq
// SIG // ZqpIpT6OA2ME3UFJI6xSl6KKdNnaXKxmHx4LtBrJ+4MY
// SIG // Pdas3EH3UQBHz5gXOKgjdbjhyTXsPawiyeBH06p4USBl
// SIG // W1ElgJs1UHNXr7eM76NKPsgdHihTt93w7GLLwyVTKvPs
// SIG // 5GswtWKRsU1Ms5J6PE6LuuSGx92TIyK8UQdofnK4w1OP
// SIG // ZtICttPhLShNRso3pduBmQW2guOwgSKljsZIqONvbFO5
// SIG // 7hL//e2+dXCsssM+8/UufDy30xAeAJX1eESdbMgVt8Jb
// SIG // 1/jsUh+VE6o7GpEKtE+kpqbqxah4Y66Vn+NEJ/qV9zD8
// SIG // aLI0+ok9VaBa48Ifogy1wckNkiVIp7/h/wz0jH02oYIX
// SIG // OjCCFzYGCisGAQQBgjcDAwExghcmMIIXIgYJKoZIhvcN
// SIG // AQcCoIIXEzCCFw8CAQMxDzANBglghkgBZQMEAgEFADB4
// SIG // BgsqhkiG9w0BCRABBKBpBGcwZQIBAQYJYIZIAYb9bAcB
// SIG // MDEwDQYJYIZIAWUDBAIBBQAEIPPS2RtQRBsifEn92dwC
// SIG // yHBarOcRY/QCc7rNzXyEUjy+AhEAw2O+ldHGen+1imcH
// SIG // Yk5L0hgPMjAyNTAzMDMxNDQ3MzZaoIITAzCCBrwwggSk
// SIG // oAMCAQICEAuuZrxaun+Vh8b56QTjMwQwDQYJKoZIhvcN
// SIG // AQELBQAwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
// SIG // Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBU
// SIG // cnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFt
// SIG // cGluZyBDQTAeFw0yNDA5MjYwMDAwMDBaFw0zNTExMjUy
// SIG // MzU5NTlaMEIxCzAJBgNVBAYTAlVTMREwDwYDVQQKEwhE
// SIG // aWdpQ2VydDEgMB4GA1UEAxMXRGlnaUNlcnQgVGltZXN0
// SIG // YW1wIDIwMjQwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAw
// SIG // ggIKAoICAQC+anOf9pUhq5Ywultt5lmjtej9kR8YxIg7
// SIG // apnjpcH9CjAgQxK+CMR0Rne/i+utMeV5bUlYYSuuM4vQ
// SIG // ngvQepVHVzNLO9RDnEXvPghCaft0djvKKO+hDu6ObS7r
// SIG // JcXa/UKvNminKQPTv/1+kBPgHGlP28mgmoCw/xi6FG9+
// SIG // Un1h4eN6zh926SxMe6We2r1Z6VFZj75MU/HNmtsgtFjK
// SIG // fITLutLWUdAoWle+jYZ49+wxGE1/UXjWfISDmHuI5e/6
// SIG // +NfQrxGFSKx+rDdNMsePW6FLrphfYtk/FLihp/feun0e
// SIG // V+pIF496OVh4R1TvjQYpAztJpVIfdNsEvxHofBf1BWka
// SIG // dc+Up0Th8EifkEEWdX4rA/FE1Q0rqViTbLVZIqi6viEk
// SIG // 3RIySho1XyHLIAOJfXG5PEppc3XYeBH7xa6VTZ3rOHNe
// SIG // iYnY+V4j1XbJ+Z9dI8ZhqcaDHOoj5KGg4YuiYx3eYm33
// SIG // aebsyF6eD9MF5IDbPgjvwmnAalNEeJPvIeoGJXaeBQjI
// SIG // K13SlnzODdLtuThALhGtyconcVuPI8AaiCaiJnfdzUcb
// SIG // 3dWnqUnjXkRFwLtsVAxFvGqsxUA2Jq/WTjbnNjIUzIs3
// SIG // ITVC6VBKAOlb2u29Vwgfta8b2ypi6n2PzP0nVepsFk8n
// SIG // lcuWfyZLzBaZ0MucEdeBiXL+nUOGhCjl+QIDAQABo4IB
// SIG // izCCAYcwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQC
// SIG // MAAwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwIAYDVR0g
// SIG // BBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMB8GA1Ud
// SIG // IwQYMBaAFLoW2W1NhS9zKXaaL3WMaiCPnshvMB0GA1Ud
// SIG // DgQWBBSfVywDdw4oFZBmpWNe7k+SH3agWzBaBgNVHR8E
// SIG // UzBRME+gTaBLhklodHRwOi8vY3JsMy5kaWdpY2VydC5j
// SIG // b20vRGlnaUNlcnRUcnVzdGVkRzRSU0E0MDk2U0hBMjU2
// SIG // VGltZVN0YW1waW5nQ0EuY3JsMIGQBggrBgEFBQcBAQSB
// SIG // gzCBgDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
// SIG // aWNlcnQuY29tMFgGCCsGAQUFBzAChkxodHRwOi8vY2Fj
// SIG // ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVk
// SIG // RzRSU0E0MDk2U0hBMjU2VGltZVN0YW1waW5nQ0EuY3J0
// SIG // MA0GCSqGSIb3DQEBCwUAA4ICAQA9rR4fdplb4ziEEkfZ
// SIG // Q5H2EdubTggd0ShPz9Pce4FLJl6reNKLkZd5Y/vEIqFW
// SIG // Kt4oKcKz7wZmXa5VgW9B76k9NJxUl4JlKwyjUkKhk3aY
// SIG // x7D8vi2mpU1tKlY71AYXB8wTLrQeh83pXnWwwsxc1Mt+
// SIG // FWqz57yFq6laICtKjPICYYf/qgxACHTvypGHrC8k1TqC
// SIG // eHk6u4I/VBQC9VK7iSpU5wlWjNlHlFFv/M93748YTeoX
// SIG // U/fFa9hWJQkuzG2+B7+bMDvmgF8VlJt1qQcl7YFUMYgZ
// SIG // U1WM6nyw23vT6QSgwX5Pq2m0xQ2V6FJHu8z4LXe/371k
// SIG // 5QrN9FQBhLLISZi2yemW0P8ZZfx4zvSWzVXpAb9k4Hpv
// SIG // pi6bUe8iK6WonUSV6yPlMwerwJZP/Gtbu3CKldMnn+Lm
// SIG // mRTkTXpFIEB06nXZrDwhCGED+8RsWQSIXZpuG4WLFQOh
// SIG // tloDRWGoCwwc6ZpPddOFkM2LlTbMcqFSzm4cd0boGhBq
// SIG // 7vkqI1uHRz6Fq1IX7TaRQuR+0BGOzISkcqwXu7nMpFu3
// SIG // mgrlgbAW+BzikRVQ3K2YHcGkiKjA4gi4OA/kz1YCsdhI
// SIG // BHXqBzR0/Zd2QwQ/l4Gxftt/8wY3grcc/nS//TVkej9n
// SIG // mUYu83BDtccHHXKibMs/yXHhDXNkoPIdynhVAku7aRZO
// SIG // wqw6pDCCBq4wggSWoAMCAQICEAc2N7ckVHzYR6z9KGYq
// SIG // XlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
// SIG // FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQ
// SIG // d3d3LmRpZ2ljZXJ0LmNvbTEhMB8GA1UEAxMYRGlnaUNl
// SIG // cnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAwMDAw
// SIG // MFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMx
// SIG // FzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQD
// SIG // EzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hB
// SIG // MjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcN
// SIG // AQEBBQADggIPADCCAgoCggIBAMaGNQZJs8E9cklRVccl
// SIG // A8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2EaFEFUJfpIjz
// SIG // aPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHx
// SIG // c7Gz7iuAhIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTn
// SIG // KC3r07G1decfBmWNlCnT2exp39mQh0YAe9tEQYncfGpX
// SIG // evA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0Cs
// SIG // X7LeSn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfA
// SIG // csW6Th+xtVhNef7Xj3OTrCw54qVI1vCwMROpVymWJy71
// SIG // h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
// SIG // 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlREr
// SIG // WHRAKKtzQ87fSqEcazjFKfPKqpZzQmiftkaznTqj1QPg
// SIG // v/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHtQr8F
// SIG // nGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+
// SIG // OcD5sjClTNfpmEpYPtMDiP6zj9NeS3YSUZPJjAw7W4oi
// SIG // qMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4JduyrXUZ1
// SIG // 4mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIz
// SIG // tM2xAgMBAAGjggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/
// SIG // AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2mi91jGogj57I
// SIG // bzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwP
// SIG // TzAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYB
// SIG // BQUHAwgwdwYIKwYBBQUHAQEEazBpMCQGCCsGAQUFBzAB
// SIG // hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
// SIG // BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNv
// SIG // bS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3J0MEMGA1Ud
// SIG // HwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
// SIG // LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAG
// SIG // A1UdIAQZMBcwCAYGZ4EMAQQCMAsGCWCGSAGG/WwHATAN
// SIG // BgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIBfmbW
// SIG // 2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnB
// SIG // zx0H6T5gyNgL5Vxb122H+oQgJTQxZ822EpZvxFBMYh0M
// SIG // CIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+rT4osequF
// SIG // zUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzv
// SIG // qLx1T7pa96kQsl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JE
// SIG // rpknG6skHibBt94q6/aesXmZgaNWhqsKRcnfxI2g55j7
// SIG // +6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFy
// SIG // nOlLAlKnN36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fm
// SIG // w0HNT7ZAmyEhQNC3EyTN3B14OuSereU0cZLXJmvkOHOr
// SIG // pgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjT
// SIG // x/no8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIX
// SIG // mVnKcPA3v5gA3yAWTyf7YGcWoWa63VXAOimGsJigK+2V
// SIG // Qbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
// SIG // AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yY
// SIG // lvZVVCsfgPrA8g4r5db7qS9EFUrnEw4d2zc4GqEr9u3W
// SIG // fPwwggWNMIIEdaADAgECAhAOmxiO+dAt5+/bUOIIQBha
// SIG // MA0GCSqGSIb3DQEBDAUAMGUxCzAJBgNVBAYTAlVTMRUw
// SIG // EwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
// SIG // dy5kaWdpY2VydC5jb20xJDAiBgNVBAMTG0RpZ2lDZXJ0
// SIG // IEFzc3VyZWQgSUQgUm9vdCBDQTAeFw0yMjA4MDEwMDAw
// SIG // MDBaFw0zMTExMDkyMzU5NTlaMGIxCzAJBgNVBAYTAlVT
// SIG // MRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsT
// SIG // EHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lD
// SIG // ZXJ0IFRydXN0ZWQgUm9vdCBHNDCCAiIwDQYJKoZIhvcN
// SIG // AQEBBQADggIPADCCAgoCggIBAL/mkHNo3rvkXUo8MCIw
// SIG // aTPswqclLskhPfKK2FnC4SmnPVirdprNrnsbhA3EMB/z
// SIG // G6Q4FutWxpdtHauyefLKEdLkX9YFPFIPUh/GnhWlfr6f
// SIG // qVcWWVVyr2iTcMKyunWZanMylNEQRBAu34LzB4TmdDtt
// SIG // ceItDBvuINXJIB1jKS3O7F5OyJP4IWGbNOsFxl7sWxq8
// SIG // 68nPzaw0QF+xembud8hIqGZXV59UWI4MK7dPpzDZVu7K
// SIG // e13jrclPXuU15zHL2pNe3I6PgNq2kZhAkHnDeMe2scS1
// SIG // ahg4AxCN2NQ3pC4FfYj1gj4QkXCrVYJBMtfbBHMqbpEB
// SIG // fCFM1LyuGwN1XXhm2ToxRJozQL8I11pJpMLmqaBn3aQn
// SIG // vKFPObURWBf3JFxGj2T3wWmIdph2PVldQnaHiZdpekjw
// SIG // 4KISG2aadMreSx7nDmOu5tTvkpI6nj3cAORFJYm2mkQZ
// SIG // K37AlLTSYW3rM9nF30sEAMx9HJXDj/chsrIRt7t/8tWM
// SIG // cCxBYKqxYxhElRp2Yn72gLD76GSmM9GJB+G9t+ZDpBi4
// SIG // pncB4Q+UDCEdslQpJYls5Q5SUUd0viastkF13nqsX40/
// SIG // ybzTQRESW+UQUOsxxcpyFiIJ33xMdT9j7CFfxCBRa2+x
// SIG // q4aLT8LWRV+dIPyhHsXAj6KxfgommfXkaS+YHS312amy
// SIG // HeUbAgMBAAGjggE6MIIBNjAPBgNVHRMBAf8EBTADAQH/
// SIG // MB0GA1UdDgQWBBTs1+OC0nFdZEzfLmc/57qYrhwPTzAf
// SIG // BgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzAO
// SIG // BgNVHQ8BAf8EBAMCAYYweQYIKwYBBQUHAQEEbTBrMCQG
// SIG // CCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5j
// SIG // b20wQwYIKwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRp
// SIG // Z2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
// SIG // QS5jcnQwRQYDVR0fBD4wPDA6oDigNoY0aHR0cDovL2Ny
// SIG // bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElE
// SIG // Um9vdENBLmNybDARBgNVHSAECjAIMAYGBFUdIAAwDQYJ
// SIG // KoZIhvcNAQEMBQADggEBAHCgv0NcVec4X6CjdBs9thbX
// SIG // 979XB72arKGHLOyFXqkauyL4hxppVCLtpIh3bb0aFPQT
// SIG // SnovLbc47/T/gLn4offyct4kvFIDyE7QKt76LVbP+fT3
// SIG // rDB6mouyXtTP0UNEm0Mh65ZyoUi0mcudT6cGAxN3J0TU
// SIG // 53/oWajwvy8LpunyNDzs9wPHh6jSTEAZNUZqaVSwuKFW
// SIG // juyk1T3osdz9HNj0d1pcVIxv76FQPfx2CWiEn2/K2yCN
// SIG // NWAcAgPLILCsWKAOQGPFmCLBsln1VWvPJ6tsds5vIy30
// SIG // fnFqI2si/xK4VC0nftg62fC2h5b9W9FcrBjDTZ9ztwGp
// SIG // n1eqXijiuZQxggN2MIIDcgIBATB3MGMxCzAJBgNVBAYT
// SIG // AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkG
// SIG // A1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
// SIG // IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0ECEAuuZrxaun+V
// SIG // h8b56QTjMwQwDQYJYIZIAWUDBAIBBQCggdEwGgYJKoZI
// SIG // hvcNAQkDMQ0GCyqGSIb3DQEJEAEEMBwGCSqGSIb3DQEJ
// SIG // BTEPFw0yNTAzMDMxNDQ3MzZaMCsGCyqGSIb3DQEJEAIM
// SIG // MRwwGjAYMBYEFNvThe5i29I+e+T2cUhQhyTVhltFMC8G
// SIG // CSqGSIb3DQEJBDEiBCAA99cRF2Umu2AHzv4gpKxdXuMw
// SIG // aAk4/hxicAwZVVuQTTA3BgsqhkiG9w0BCRACLzEoMCYw
// SIG // JDAiBCB2dp+o8mMvH0MLOiMwrtZWdf7Xc9sF1mW5BZOY
// SIG // Q4+a2zANBgkqhkiG9w0BAQEFAASCAgCOAqt8A8BRy16H
// SIG // Ot9TiVA3Csucg6WY8+Xr0z47hibN5m6zIMbdJ5FGyl+e
// SIG // WdpxiSukM3ldd2hEdq7qq5Fom6dICUz9CQnN+JHRH+jK
// SIG // PJWSy5VoMyaAb28vl9exRvq1ur3R5S4dstvDqxika8+l
// SIG // mf3i7E6wp4zf60rDPHEybmHwAq44YUnu9HMztMPprlC9
// SIG // p20RcSvF6B9BhHk8jv2v0kIDuSlUTUxVvn1SkgByvSbS
// SIG // QNLYVynom7KUg6G16Sw+KGJvr8wA28Lv33d8KUO9HFRg
// SIG // gEHypmvBIn7QDNtAgc5ZtsVGwvkkMTJBOOJqvyAzcD04
// SIG // gpjUEurhef9KvB5hPv9jIh2GM6YODMXoU/6zp0qP7sXB
// SIG // Xy02d5XNxJVxvkSsXc6v5TRGJ8Iibts6HIKFi3UITUX4
// SIG // E/7Ei3zhAjQmJloJ1RfkR1DtVKGpiyBeMGIb/cdjt9nO
// SIG // Yl27dNtDSZji3QcEaioQUrRxaN5FohptpV1ipvPqLybV
// SIG // l1os49vc5WAO89SX1JYt4BwTHUh+gHU77UW+EJE61r/m
// SIG // h4zWiaWURlMJnwywLBi4K5qNT1oVNRk7q3Gnv+4uvAJ1
// SIG // H/21NVgcB2ob+6uFROc0UJZVQOJoIls9P3+Y9Sb0Y+KY
// SIG // npreOOmYjyrWX5nreMnd5g+ihRC011nyFLlZCrsbW5q0
// SIG // 9ErAu1cuBg==
// SIG // End signature block
